C      *****************************************************************
C      * Subroutine Init                                               *
C      * initializes the parameters in the common block VParam, file   *
C      * VModel.f.  These parameters are the species types. The        *
C      * parameters are:                                               *
C      *                                                               *
C      * Carb      -Output- The array index for carbon.  Unitless.     *
C      *                    (Common block VDecomp, file VModel.f)      *
C      * CE        -Output- The array index for cellulose to           *
C      *                    extractives.  Unitless.                    *
C      *                    (Common block VDecomp, file VModel.f)      *
C      * Cell      -Output- The array index for cellulose.  Unitless.  *
C      *                    (Common block VDecomp, file VModel.f)      *
C      * EL        -Output- The array index for extractives to lignin. *
C      *                    Unitless.                                  *
C      *                    (Common block VDecomp, file VModel.f)      *
C      * Extr      -Output- The array index for extractives.  Unitless.*
C      *                    (Common block VDecomp, file VModel.f)      *
C      * FixAct    -Output- Indicates a species with fixed activity,   *
C      *                    i.e., there is a known concentration of    *
C      *                    this component.  Unitless.                 *
C      *                    (Common block VParam, file VModel.f)       *
C      * HE        -Output- The array index for humus to extractives.  *
C      *                    Unitless.                                  *
C      *                    (Common block VDecomp, file VModel.f)      *
C      * Humu      -Output- The array index for humus.  Unitless.      *
C      *                    (Common block VDecomp, file VModel.f)      *
C      * LE        -Output- The array index for lignin to extractives. *
C      *                    Unitless.                                  *
C      *                    (Common block VDecomp, file VModel.f)      *
C      * LH        -Output- The array index for lignin to humus.       *
C      *                    Unitless.                                  *
C      *                    (Common block VDecomp, file VModel.f)      *
C      * Lign      -Output- The array index for lignin.  Unitless.     *
C      *                    (Common block VDecomp, file VModel.f)      *
C      * MasBal    -Output- Indicates a species that is limited by     *
C      *                    mass balance.  Unitless.                   *
C      *                    (Common block VModel, file VModel.f)       *
C      * Nitr      -Output- An array index for nitrogen.  Unitless.    *
C      *                    (Common block VDecomp, file VModel.f)      *
C      * NullType  -Output- A null species type (equals zero).         *
C      *                    Unitless.                                  *
C      *                    (Common block VParam, file VModel.f)       *
C      * SolGas    -Output- Indicates a species that is solid or       *
C      *                    gaseous controlled.  Unitless.             *
C      *                    (Common block VParam, file VModel.f)       *
C      * SPMasBal  -Output- Indicates a solid phase species type       *
C      *                    limited by mass balance.  Unitless.        *
C      *                    (Common block VModel, file VModel.f)       *
C      * SPFixAct  -Output- Indicates a solid phase species type with  *
C      *                    fixed activity, i.e.,  there is a known    *
C      *                    concentration of this species.  Unitless.  *
C      *                    (Common block VParam, file VModel.f)       *
C      * SPSolGas  -Output- Indicates a solid phase species type that  *
C      *                    is solid or gaseous controlled.  Unitless. *
C      *                    (Common block VParam, file VModel.f)       *
C      *****************************************************************
       SUBROUTINE INIT
							IMPLICIT NONE
  					INCLUDE 'VMODEL.INC'
	   
C      *---------------------------------*
C      * Initialize species type numbers *
C      *---------------------------------*
	      NULLTYPE=0
							MASBAL=1
							FIXACT=2
							SOLGAS=3
							SPMASBAL=11
							SPFIXACT=12
							SPSOLGAS=13

C      *----------------------------------------------*
C      * Initialize indices for decomposition arrays. *
C      *----------------------------------------------*
       CELL = 1
							EXTR = 2
							LIGN = 3
							HUMU = 4

       CE = 1
       EL = 2
       HE = 3
       LE = 4
       LH = 5

       CARB = 1
       NITR = 2

       WRITE(6,*) 'Working...'

							RETURN
							END
C      *****************************************************************
C      *                    END SUBROUTINE                             *
C      *****************************************************************
